
struct light
{
  vec3 position;
  vec4 ambient;
  vec4 diffuse;
  vec4 specular;
  
  // only directional light is supported
};

const float c_zero = 0.0;
const float c_one = 1.0;

uniform light u_lights[1];

attribute vec4 a_position;
attribute vec3 a_normal;
attribute vec2 a_texCoord;

varying vec2 v_texCoord;
varying vec4 v_color;

uniform mat4 u_matWVP;
uniform mat3 u_matWVNormals;

uniform vec2 u_textureOffset;

void main()
{
  float ndotl;
  vec3 n;
  
  n = u_matWVNormals * a_normal;
  
  ndotl = max(dot(u_lights[0].position.xyz,n), c_zero);
  v_color = vec4(u_lights[0].ambient[0] + ndotl * u_lights[0].diffuse[0], u_lights[0].ambient[1] + ndotl * u_lights[0].diffuse[1], u_lights[0].ambient[2] + ndotl * u_lights[0].diffuse[2], u_lights[0].ambient[3] + ndotl * u_lights[0].diffuse[3]);
  
  gl_Position = u_matWVP * a_position;
  v_texCoord = a_texCoord + u_textureOffset;
}
